package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client.dto.InputCreateUserNotificationDto;
import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.client.dto.OutputUserNotificationDto;
import jakarta.validation.Valid;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * Notification BS microservice client.
 */
public interface NotificationBsClient {

    /**
     * Creates new users notifications.
     *
     * @param request the input data transfer object containing user notification details
     * @return the created notifications
     */
    @PostMapping(
            value = "/notification/notifications",
            consumes = MediaType.APPLICATION_JSON_VALUE,
            produces = MediaType.APPLICATION_JSON_VALUE
    )
    List<OutputUserNotificationDto> create(
            @Valid @RequestBody InputCreateUserNotificationDto request);

}
