package com.finconsgroup.itserr.marketplace.notificationfeeder.bs.config;

import com.finconsgroup.itserr.marketplace.notificationfeeder.bs.event.filter.ConsumerHandlerFilter;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * Configuration class that provides filter beans for consumer message handlers. These filters are used to determine if a notification handler should process a
 * specific cloud event.
 */
@Configuration
public class ConsumerHandlerFiltersConfiguration {

    /**
     * Creates a filter bean that checks if the notification type of the handler matches the cloud event type.
     *
     * @return a ConsumerHandlerFilter that validates notification type matching
     */
    @Bean
    @Order(Ordered.HIGHEST_PRECEDENCE)
    public ConsumerHandlerFilter notificationType() {
        return (handler, event) -> StringUtils.equals(
                handler.getNotificationType(),
                event.getType());
    }

}
