package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;

/**
 * It represents the payload for image field to create/update a Catalog search document.
 */
@Builder
@Schema(
    title = "Create/Update Catalog search document image DTO",
    description = "Represents the payload for image field to create/update a Catalog search document"
)
@Data
public class InputCatalogImageDto {

    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "Name",
        example = "Test Resource")
    private String name;

    @Schema(
        description = "Description",
        example = "Test Resource Description")
    private String description;

    @Schema(
        description = "Format",
        example = "png")
    private String format;

    @Schema(
        description = "URL",
        example = "http://localhost/resource/1.html")
    private String url;

    @Schema(
        description = "Created",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant created;

    @Schema(
        description = "State",
        example = "active")
    private String state;

    @Schema(
        description = "Last Modified",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant lastModified;

    @Schema(
        description = "Package ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String packageId;

    @Schema(
        description = "Revision ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String revisionId;

    @Schema(
        description = "Resource Type",
        example = "resource")
    private String resourceType;

}
