package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;

/**
 * It represents the payload for resources field to create/update a Catalog search document.
 */
@Builder
@Schema(
    title = "Create/Update Catalog search document resource DTO",
    description = "Represents the payload for resources field to create/update a Catalog search document"
)
@Data
public class InputCatalogResourceDto {

    @Schema(
        description = "ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "MIME Type",
        example = "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")
    private String mimetype;

    @Schema(
        description = "Cache URL",
        example = "http://localhost/cache/test")
    private String cacheUrl;

    @Schema(
        description = "Hash",
        example = "8743b52063cd84097a65d1633f5c74f5")
    private String hash;

    @Schema(
        description = "Description",
        example = "Test Resource Description")
    private String description;

    @Schema(
        description = "Name",
        example = "Test Resource")
    private String name;

    @Schema(
        description = "Format",
        example = "xlsx")
    private String format;

    @Schema(
        description = "URL",
        example = "http://localhost/resource/1.html")
    private String url;

    @Schema(
        description = "Datastore Active",
        example = "true")
    private Boolean datastoreActive;

    @Schema(
        description = "Created",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant created;

    @Schema(
        description = "State",
        example = "active")
    private String state;

    @Schema(
        description = "Last Modified",
        example = "2025-03-31T09:29:20.428656Z")
    private Instant lastModified;

    @Schema(
        description = "Package ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String packageId;

    @Schema(
        description = "Revision ID",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String revisionId;

    @Schema(
        description = "Resource Type",
        example = "resource")
    private String resourceType;

}
