package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.finconsgroup.itserr.marketplace.core.web.dto.PutIdParameterBody;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotBlank;
import lombok.Builder;
import lombok.Data;

import java.time.Instant;
import java.util.List;

/**
 * It represents the payload to create/update News search document.
 */
@Builder
@Schema(name = "InputNewsDto",
        title = "Create/Update News search document DTO",
        description = "Represents the payload to create/update an News search document")
@Data
public class InputNewsDto implements PutIdParameterBody {

    @Schema(description = "Unique identifier of the news", example = "550e8400-e29b-41d4-a716-446655440000")
    @NotBlank
    private String id;

    @Schema(description = "The title of the news", example = "Annual Tech Conference 2025")
    private String title;

    @Schema(description = "The creator of the News")
    private RegisteredAuthorDto creator;

    @Schema(description = "The type of news", example = "Technology")
    private String newsType;

    @Schema(description = "The content of the news", example = "Join us for the biggest tech conference of the year...")
    private String content;

    @Schema(description = "List of tags associated with the news", example = "[\"technology\", \"sports\"]")
    private List<String> tags;

    @Schema(description = "List of institutional pages")
    private List<InstitutionalPageMinimalDto> institutionalPages;

    @Schema(description = "The image for the news")
    private ImageMinimalDto image;

    @Schema(description = "Authors registered and unregistered of the News")
    private List<RegisteredAuthorDto> authors;

    @Schema(description = "The creation time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant creationTime;

    @Schema(description = "The last update time of the table record", example = "2025-06-20T15:29:06.254836Z")
    private Instant updateTime;

    @Schema(hidden = true)
    @JsonIgnore
    @Hidden
    @Override
    public String getPutId() {
        return id;
    }
}