package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.Instant;
import java.util.List;

@Schema(name = "InstitutionalPagePublicationDto", description = "DTO of a publication for an institutional page")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InstitutionalPagePublicationDto {
    private String id;

    private String name;
    private String title;
    private String description;

    private String status;

    private String version;

    private String creatorEmail;

    private List<AuthorDto> authors;
    private AuthorDto maintainer;

    private Instant createTs;
    private Instant updateTs;

    private String type;

    private String url;

    private String licenseTitle;

    private int numTags;
}