package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the payload for location field of a search document.
 */
@Builder
@Schema(
    title = "DTO for Location field of search document",
    description = "Represents the payload for location field to create/update a search document"
)
@Data
public class LocationDto {

    @Schema(
        description = "Zip Code",
        example = "12345")
    private String zipCode;

    @Schema(
        description = "City",
        example = "Palermo")
    private String city;

    @Schema(
        description = "Region",
        example = "Sicily")
    private String region;

    @Schema(
        description = "Country",
        example = "Italy")
    private String country;
}
