package com.finconsgroup.itserr.marketplace.search.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.ToString;

import java.util.List;

/**
 * It represents the result for autocompletion of Global Search.
 */
@RequiredArgsConstructor
@Getter
@Builder(toBuilder = true)
@Schema(
    title = "Global Search Auto Complete Result DTO",
    description = "Represents the response for Global Search auto complete"
)
@EqualsAndHashCode
@ToString
public class OutputGlobalSearchAutoCompleteDto {
    @Schema(
        description = "Category to which the document belongs",
        example = "Projects")
    private final String category;

    @Schema(
        description = "The list of documents for the category")
    private final List<OutputGlobalSearchAutoCompleteDataDto> data;
}
