package com.finconsgroup.itserr.marketplace.search.dm.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Builder;
import lombok.Data;

/**
 * It represents the minimal response payload for User Profile field.
 */
@Builder
@Schema(
    title = "Response for User Profile Dto",
    description = "Represents the minimal response payload for User Profile field"
)
@Data
public class UserProfileMinimalDto {

    @Schema(
        description = "Id",
        example = "123e4567-e89b-12d3-a456-426614174000")
    private String id;

    @Schema(
        description = "First Name",
        example = "John")
    private String firstName;

    @Schema(
        description = "Last Name",
        example = "Doe")
    private String lastName;

    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @Schema(
        description = "Email",
        example = "john.doe@example.com",
        accessMode = Schema.AccessMode.WRITE_ONLY)
    private String email;

    @Schema(
        description = "orcid",
        example = "00000-00000-00000-00000")
    private String orcid;
}
