package com.finconsgroup.itserr.marketplace.search.dm.entity;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.finconsgroup.itserr.marketplace.search.dm.constant.DateTimeFormats;
import com.finconsgroup.itserr.marketplace.search.dm.converter.InstantPropertyValueConverter;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.annotations.ValueConverter;
import org.springframework.data.elasticsearch.annotations.WriteTypeHint;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;

/**
 * It represents the persistent structure of Event Search document for both Global and Local search.
 */
@SuppressWarnings("DefaultAnnotationParam")
@Document(
        indexName = "#{@environment.getProperty('search-dm.event.search.index-name','itserr-alias-wp2-search-event')}",
        createIndex = false,
        alwaysWriteMapping = false,
        writeTypeHint = WriteTypeHint.FALSE
)
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
@JsonIgnoreProperties(ignoreUnknown = true)
public class Event implements ScoredDocument {

    @Id
    private String id;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String title;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String eventLink;

    @Field(type = FieldType.Keyword)
    private String eventType;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private String content;

    @Field(type = FieldType.Integer)
    private Integer subscribedParticipantsCount;

    @Field(type = FieldType.Keyword)
    private List<String> tags;

    @Field(type = FieldType.Object)
    private List<InstitutionalPageMinimal> institutionalPages;

    @MultiField(mainField = @Field(type = FieldType.Text),
            otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
    private ImageMinimal image;

    @Field(type = FieldType.Keyword)
    private String timezone;

    @Field(type = FieldType.Date, format = {DateFormat.date})
    private LocalDate startDate;

    @Field(type = FieldType.Date, format = {DateFormat.date})
    private LocalDate endDate;

    @Field(type = FieldType.Object)
    private List<EventConductor> eventConductors;

    @Field(type = FieldType.Object)
    private List<Schedule> schedules;

    @Field(type = FieldType.Nested)
    private List<SubscribedParticipant> subscribedParticipants;

    @Field(type = FieldType.Object)
    private UserProfileMinimal eventPlanner;

    @Field(type = FieldType.Object)
    private UserProfileMinimal maintainer;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant creationTime;

    @ValueConverter(InstantPropertyValueConverter.class)
    @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
    private Instant updateTime;

    @Transient
    private Double score;

    /**
     * It represents the persistent structure of subscribed participant field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class SubscribedParticipant {

        @Field(type = FieldType.Keyword)
        private String id;

        @Field(type = FieldType.Keyword)
        private String eventId;

        @Field(type = FieldType.Keyword)
        private String userId;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String firstName;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String lastName;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String email;

        @Field(type = FieldType.Keyword)
        private String orcid;

        @Field(type = FieldType.Object)
        private List<SubscribedProgram> subscribedPrograms;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant creationTime;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant updateTime;

    }

    /**
     * It represents the persistent structure of schedule field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Schedule {

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @Field(type = FieldType.Date, format = {DateFormat.date})
        private LocalDate startDate;

        @Field(type = FieldType.Date, format = {DateFormat.hour_minute_second})
        private LocalTime startTime;

        @Field(type = FieldType.Date, format = {DateFormat.hour_minute_second})
        private LocalTime endTime;

        @Field(type = FieldType.Object)
        private Location location;

        @Field(type = FieldType.Object)
        private List<Program> programs;

    }

    /**
     * It represents the persistent structure of program field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class Program {

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String programLink;

        @Field(type = FieldType.Object)
        private List<ProgramConductor> programConductors;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String place;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String street;

        @Field(type = FieldType.Integer)
        private Integer maxParticipants;

        @Field(type = FieldType.Integer)
        private Integer subscribedParticipantsCount;

        @Field(type = FieldType.Object)
        private List<ProgramSubscribedParticipant> subscribedParticipants;

        @Field(type = FieldType.Date, format = {DateFormat.hour_minute_second})
        private LocalTime startTime;

        @Field(type = FieldType.Date, format = {DateFormat.hour_minute_second})
        private LocalTime endTime;

    }

    /**
     * It represents the persistent structure of subscribed participant field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class ProgramSubscribedParticipant {

        @Field(type = FieldType.Keyword)
        private String id;

        @Field(type = FieldType.Keyword)
        private String programId;

        @Field(type = FieldType.Keyword)
        private String userId;

        @Field(type = FieldType.Boolean)
        private Boolean remoteParticipation;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant creationTime;

        @ValueConverter(InstantPropertyValueConverter.class)
        @Field(type = FieldType.Date, format = {}, pattern = DateTimeFormats.INSTANT_OPEN_SEARCH)
        private Instant updateTime;

    }

    /**
     * It represents the persistent structure of subscribed programs field for both Global and Local search.
     */
    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    @Builder
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static class SubscribedProgram {

        @Field(type = FieldType.Keyword)
        private String id;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String title;

        @MultiField(mainField = @Field(type = FieldType.Text),
                otherFields = {@InnerField(suffix = "keyword", type = FieldType.Keyword, ignoreAbove = 256)})
        private String description;

        @Field(type = FieldType.Boolean)
        private Boolean remoteParticipation;

    }
}
