package com.finconsgroup.itserr.marketplace.search.dm.entity;

/**
 * Interface for documents that can support score on read.
 */
public interface ScoredDocument {

    /**
     * Returns the score from the search
     *
     * @return score
     */
    Double getScore();

    /**
     * Sets the search score on the document.
     * This attribute should not be persisted in the database.
     *
     * @param score the score to set
     */
    void setScore(Double score);
}
