package com.finconsgroup.itserr.marketplace.search.dm.mapper;

import com.finconsgroup.itserr.marketplace.search.dm.dto.InputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputNewsLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.News;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

/**
 * Mapper for all dto/entity conversions related to {@link News}
 */
@Mapper(config = MapperConfiguration.class, uses = {UserProfileMapper.class})
public interface NewsMapper {

    @Mapping(target = "score", ignore = true)
    News toEntity(InputNewsDto dto);

    OutputNewsDto toDto(News entity);

    OutputGlobalSearchAutoCompleteDataDto toAutoCompleteDataDto(News entity);

    OutputNewsLocalSearchDto toLocalSearchDto(News entity);

    @Mapping(target = "description", source = "content")
    @Mapping(target = "imageUrl", source = "image.url")
    OutputGlobalSearchDataDto toGlobalSearchDataDto(News entity);

}
