package com.finconsgroup.itserr.marketplace.search.dm.repository;

import com.finconsgroup.itserr.marketplace.search.dm.bean.QueryRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * Interface to declare methods that use custom queries and are not supported by the
 * Spring Data Repository.
 */
public interface CustomQueryRepository {

    /**
     * Find top hits result for the query request
     *
     * @param queryRequest the query to perform search
     * @param topHitsLimit the number of top hit results to return
     * @param <T>          the type of the document
     * @return the list of found documents
     */
    <T> List<T> findTopHitsForQuery(QueryRequest<T> queryRequest, int topHitsLimit);

    /**
     * Find the page of result for the query request
     *
     * @param queryRequest the query to perform search
     * @param pageable     the page of results to return
     * @param <T>          the type of the document
     * @return the page of found documents
     */
    <T> Page<T> findPageForQuery(QueryRequest<T> queryRequest, Pageable pageable);
}
