package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.CatalogService;
import com.finconsgroup.itserr.marketplace.search.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.search.dm.service.GlobalSearchService;
import com.finconsgroup.itserr.marketplace.search.dm.service.InstitutionalPageService;
import com.finconsgroup.itserr.marketplace.search.dm.service.NewsService;
import com.finconsgroup.itserr.marketplace.search.dm.service.UserProfileService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * Default implementation of {@link GlobalSearchService} to perform search operations by connecting to an
 * OpenSearch instance.
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class DefaultGlobalSearchService implements GlobalSearchService {

    private final CatalogService catalogService;
    private final UserProfileService userProfileService;
    private final InstitutionalPageService institutionalPageService;
    private final EventService eventService;
    private final NewsService newsService;

    @Override
    @NonNull
    @Transactional(readOnly = true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        List<OutputGlobalSearchAutoCompleteDto> autoCompleteResultList = new ArrayList<>();
        autoCompleteResultList.addAll(catalogService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(userProfileService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(institutionalPageService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(eventService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(newsService.getAutoCompletions(terms));
        return autoCompleteResultList;
    }

    @Override
    @NonNull
    @Transactional(readOnly = true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        List<OutputGlobalSearchDto> searchResultList = new ArrayList<>();
        searchResultList.addAll(catalogService.getSearch(terms));
        searchResultList.addAll(userProfileService.getSearch(terms));
        searchResultList.addAll(institutionalPageService.getSearch(terms));
        searchResultList.addAll(eventService.getSearch(terms));
        searchResultList.addAll(newsService.getSearch(terms));
        return searchResultList;
    }
}
