/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.api;

import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidPutIdParameters;
import com.finconsgroup.itserr.marketplace.core.web.validation.annotation.ValidQueryFilter;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputFavouriteSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogFavouriteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputCatalogLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Sort;
import org.springframework.http.HttpStatus;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="Catalog", description="Operations related to catalog search")
@Validated
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="500", ref="InternalServerError")})
public interface CatalogApi {
    @Operation(summary="Create/Update document in Catalog Search index", description="Create a new document or update an existing document entry in the Catalog Search index using the provided dto. It also performs validations and returns errors in case of validation failures")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @PutMapping(value={"/catalog/{id}"}, produces={"application/json"}, consumes={"application/json"})
    @ValidPutIdParameters
    public OutputCatalogDto upsertCatalog(@PathVariable(value="id") String var1, @Valid @RequestBody InputCatalogDto var2);

    @Operation(summary="Fetches document from Catalog Search index", description="Fetches a document entry in the Catalog Search index using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", ref="NotFound")})
    @GetMapping(value={"/catalog/{id}"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public OutputCatalogDto getCatalog(@PathVariable(value="id") String var1);

    @Operation(summary="Deletes document from Catalog Search index", description="Deletes a document entry in the Catalog Search index using the provided id.It returns not found response in case if the id does not exist")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", ref="NotFound")})
    @DeleteMapping(value={"/catalog/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCatalog(@PathVariable(value="id") String var1);

    @Operation(summary="Deletes all the documents from Catalog Search index", description="Deletes all the documents in the Catalog Search index.", hidden=true)
    @ApiResponses(value={@ApiResponse(responseCode="204", description="No Content")})
    @DeleteMapping(value={"/catalog-all"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAll();

    @Operation(summary="Perform catalog search for autocompletion and retrieve the results", description="Perform catalog search for autocompletion based on the terms provided and retrieve results")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/catalog/auto-complete"}, produces={"application/json"})
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NotNull @Size(min=3) @RequestParam(value="terms") @NotNull @Size(min=3) String var1);

    @Operation(summary="Perform catalog local search and retrieve the results", description="Perform the catalog local search based on the terms and filters provided and retrieve results", parameters={@Parameter(name="terms", description="The terms to search for"), @Parameter(name="filters", description="The additional filters to apply in the format key1=value1,value2&key2=value3,value4"), @Parameter(name="pageNumber", description="The page index, starting from 0"), @Parameter(name="pageSize", description="The number of items per page"), @Parameter(name="sort", description="The field by which to sort the results"), @Parameter(name="direction", description="The sorting direction: ASC or DESC"), @Parameter(name="multiSort", description="The multiple fields to sort by, takes preference over sort in the format field1,field2:desc,field3")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/catalog/search"}, produces={"application/json"})
    public Page<OutputCatalogLocalSearchDto> getLocalSearch(@Size(min=3) @RequestParam(value="terms", required=false) @Size(min=3) String var1, @RequestParam(value="filters", required=false) @ValidQueryFilter(configKey="catalog") String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="relevance", required=false) String var5, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var6, @RequestParam(name="multiSort", defaultValue="", required=false) String var7);

    @Operation(summary="Perform catalog favourite search and retrieve the results", description="Perform the catalog favourite search based on the ids and filters provided and retrieve results")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @PostMapping(value={"/catalog/favourite"}, produces={"application/json"}, consumes={"application/json"})
    public Page<OutputCatalogFavouriteDto> getFavourite(@Valid @RequestBody InputFavouriteSearchDto var1, @RequestParam(value="filters", required=false) @ValidQueryFilter(configKey="catalog") String var2, @RequestParam(name="pageNumber", defaultValue="0", required=false) @PositiveOrZero int var3, @RequestParam(name="pageSize", defaultValue="10", required=false) @Positive int var4, @RequestParam(name="sort", defaultValue="relevance", required=false) String var5, @RequestParam(name="direction", defaultValue="DESC", required=false) Sort.Direction var6);
}

