/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.api;

import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.List;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Tag(name="GlobalSearch", description="Operations related to global search")
@SecurityRequirement(name="BearerAuth")
@ApiResponses(value={@ApiResponse(responseCode="500", ref="InternalServerError")})
public interface GlobalSearchApi {
    @Operation(summary="Perform global search for autocompletion and retrieve the results", description="Perform the global for autocompletion search based on the terms provided and retrieve results")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/global/auto-complete"}, produces={"application/json"})
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NotNull @Size(min=3) @RequestParam(value="terms") @NotNull @Size(min=3) String var1);

    @Operation(summary="Perform global search retrieve the results", description="Perform the global search based on the terms provided and retrieve results")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="400", ref="BadRequest")})
    @ResponseStatus(value=HttpStatus.OK)
    @GetMapping(value={"/global/search"}, produces={"application/json"})
    public List<OutputGlobalSearchDto> getSearch(@NotNull @Size(min=3) @RequestParam(value="terms") @NotNull @Size(min=3) String var1);
}

