/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.controller;

import com.finconsgroup.itserr.marketplace.search.dm.api.EventApi;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputEventLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.search.dm.util.SortUtils;
import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventController
implements EventApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EventController.class);
    private final EventService eventService;

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(String.class, (PropertyEditor)new StringTrimmerEditor(false));
    }

    @NonNull
    public OutputEventDto upsertEvent(String id, InputEventDto dto) {
        return (OutputEventDto)this.eventService.upsertDocument((Object)dto);
    }

    @NonNull
    public OutputEventDto getEvent(String id) {
        return (OutputEventDto)this.eventService.getDocument(id);
    }

    public void deleteEvent(String id) {
        this.eventService.deleteDocument(id);
    }

    public void deleteAll() {
        this.eventService.deleteAll();
    }

    @NonNull
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        return this.eventService.getAutoCompletions(terms);
    }

    @NonNull
    public Page<OutputEventLocalSearchDto> getLocalSearch(@Nullable String terms, @Nullable String filters, int pageNumber, int pageSize, String sort, Sort.Direction direction, String multiSort) {
        Sort sortToApply = SortUtils.buildSort((String)sort, (Sort.Direction)direction, (String)multiSort, (String)":", Map.of());
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)pageSize, (Sort)sortToApply);
        return this.eventService.getLocalSearch(terms, filters, (Pageable)pageable);
    }

    @Generated
    public EventController(EventService eventService) {
        this.eventService = eventService;
    }
}

