/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.service.CatalogService;
import com.finconsgroup.itserr.marketplace.search.dm.service.EventService;
import com.finconsgroup.itserr.marketplace.search.dm.service.GlobalSearchService;
import com.finconsgroup.itserr.marketplace.search.dm.service.InstitutionalPageService;
import com.finconsgroup.itserr.marketplace.search.dm.service.NewsService;
import com.finconsgroup.itserr.marketplace.search.dm.service.UserProfileService;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultGlobalSearchService
implements GlobalSearchService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultGlobalSearchService.class);
    private final CatalogService catalogService;
    private final UserProfileService userProfileService;
    private final InstitutionalPageService institutionalPageService;
    private final EventService eventService;
    private final NewsService newsService;

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@NonNull String terms) {
        ArrayList<OutputGlobalSearchAutoCompleteDto> autoCompleteResultList = new ArrayList<OutputGlobalSearchAutoCompleteDto>();
        autoCompleteResultList.addAll(this.catalogService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(this.userProfileService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(this.institutionalPageService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(this.eventService.getAutoCompletions(terms));
        autoCompleteResultList.addAll(this.newsService.getAutoCompletions(terms));
        return autoCompleteResultList;
    }

    @NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@NonNull String terms) {
        ArrayList<OutputGlobalSearchDto> searchResultList = new ArrayList<OutputGlobalSearchDto>();
        searchResultList.addAll(this.catalogService.getSearch(terms));
        searchResultList.addAll(this.userProfileService.getSearch(terms));
        searchResultList.addAll(this.institutionalPageService.getSearch(terms));
        searchResultList.addAll(this.eventService.getSearch(terms));
        searchResultList.addAll(this.newsService.getSearch(terms));
        return searchResultList;
    }

    @Generated
    public DefaultGlobalSearchService(CatalogService catalogService, UserProfileService userProfileService, InstitutionalPageService institutionalPageService, EventService eventService, NewsService newsService) {
        this.catalogService = catalogService;
        this.userProfileService = userProfileService;
        this.institutionalPageService = institutionalPageService;
        this.eventService = eventService;
        this.newsService = newsService;
    }
}

