/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.util;

import io.micrometer.common.util.StringUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SortUtils {
    private static final String MULTI_SORT_SEPARATOR = ",";

    private SortUtils() {
        throw new UnsupportedOperationException("SortUtils cannot be instantiated");
    }

    @NonNull
    public static Sort buildSort(@NonNull List<String> sortFields, @NonNull String separator, @Nullable Map<String, String> propertyNameMap) {
        AtomicReference<Sort> sortResult = new AtomicReference<Sort>(Sort.unsorted());
        sortFields.stream().map(s -> s.split(separator, 2)).map(arr -> {
            String propertyName = SortUtils.mapSortProperty((Map)propertyNameMap, (String)arr[0]);
            if (((String[])arr).length == 1) {
                return Sort.by((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{propertyName});
            }
            return Sort.by((Sort.Direction)Sort.Direction.fromString((String)arr[1]), (String[])new String[]{propertyName});
        }).forEach(sort -> sortResult.getAndAccumulate((Sort)sort, Sort::and));
        return sortResult.get();
    }

    @NonNull
    public static Sort buildSort(@NonNull String sort, @NonNull Sort.Direction direction, String multiSort, @NonNull String separator, @Nullable Map<String, String> propertyNameMap) {
        Sort sortResult;
        if (StringUtils.isNotBlank((String)multiSort)) {
            List<String> sortFields = Arrays.asList(multiSort.split(","));
            sortResult = SortUtils.buildSort(sortFields, (String)separator, propertyNameMap);
        } else {
            sortResult = Sort.by((Sort.Direction)direction, (String[])new String[]{SortUtils.mapSortProperty(propertyNameMap, (String)sort)});
        }
        return sortResult;
    }

    @NonNull
    public static Sort mapSortProperty(@Nullable Map<String, String> propertyMap, @NonNull Sort sort) {
        AtomicReference<Sort> sortResult = new AtomicReference<Sort>(Sort.unsorted());
        ((Stream)sort.stream().sequential()).map(o -> Sort.by((Sort.Direction)o.getDirection(), (String[])new String[]{SortUtils.mapSortProperty((Map)propertyMap, (String)o.getProperty())})).forEach(newSort -> sortResult.getAndAccumulate((Sort)newSort, Sort::and));
        return sortResult.get();
    }

    @NonNull
    private static String mapSortProperty(@Nullable Map<String, String> propertyMap, @NonNull String property) {
        return Optional.ofNullable(propertyMap).map(m -> m.getOrDefault(property, property)).orElse(property);
    }
}

