package com.finconsgroup.itserr.marketplace.search.dm.bean;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import lombok.Builder;

import java.util.List;

/**
 * The search request containing the common search parameters like terms, ids and query filters
 *
 * @param terms the terms to search for
 * @param ids the list of document ids to fetch
 * @param queryFilters the queryFilters to be applied to fields
 * @param termSearchFields the list of {@link QuerySearchFields} to search for keyword terms
 */
@Builder
public record SearchRequest(String terms,
                            List<String> ids,
                            List<QueryFilter> queryFilters,
                            List<QuerySearchFields> termSearchFields) {
}
