/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.api;

import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputIngestDataDto;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

@Tag(name="Diagnostics", description="Diagnostics API: provides endpoints used for debugging and runtime analysis.")
@SecurityRequirement(name="BearerAuth")
public interface DiagnosticsApi {
    @Operation(summary="Download log file", responses={@ApiResponse(responseCode="200", description="OK")})
    @GetMapping(path={"/search/diagnostics/download-logs"}, produces={"application/octet-stream"})
    public ResponseEntity<Resource> downloadLogs();

    @Operation(summary="Ingest data in an index represented by the category for testing purposes", responses={@ApiResponse(responseCode="200", description="OK")})
    @PostMapping(path={"/search/diagnostics/ingest/{category}"}, consumes={"text/plain"}, produces={"application/json"})
    public ResponseEntity<OutputIngestDataDto> ingestData(@PathVariable Category var1, @RequestBody String var2);
}

