/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.search.dm.service.impl;

import com.finconsgroup.itserr.marketplace.core.web.bean.QueryFilter;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2BusinessException;
import com.finconsgroup.itserr.marketplace.core.web.exception.WP2ResourceNotFoundException;
import com.finconsgroup.itserr.marketplace.search.dm.bean.PostProcessFilterResult;
import com.finconsgroup.itserr.marketplace.search.dm.bean.SearchRequest;
import com.finconsgroup.itserr.marketplace.search.dm.config.DefaultSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.DiscussionSearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.config.SearchProperties;
import com.finconsgroup.itserr.marketplace.search.dm.dto.InputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputDiscussionLocalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchAutoCompleteDto;
import com.finconsgroup.itserr.marketplace.search.dm.dto.OutputGlobalSearchDto;
import com.finconsgroup.itserr.marketplace.search.dm.entity.Discussion;
import com.finconsgroup.itserr.marketplace.search.dm.entity.UserProfile;
import com.finconsgroup.itserr.marketplace.search.dm.enums.Category;
import com.finconsgroup.itserr.marketplace.search.dm.event.UserProfileUpdatedEvent;
import com.finconsgroup.itserr.marketplace.search.dm.mapper.DiscussionMapper;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomAggregationRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.CustomQueryRepository;
import com.finconsgroup.itserr.marketplace.search.dm.repository.DiscussionRepository;
import com.finconsgroup.itserr.marketplace.search.dm.service.DiscussionService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DefaultDiscussionService
implements DiscussionService,
ApplicationListener<UserProfileUpdatedEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DefaultDiscussionService.class);
    private static final String CREATOR_USER_ID_FIELD_NAME = "userInfoDTO.id";
    private static final String FILTER_KEY_VISIBILITY = "visibility";
    private static final List<String> FILTER_VISIBILITY_DEFAULT_VALUE = List.of("public");
    private final DiscussionRepository discussionRepository;
    private final DiscussionMapper discussionMapper;
    private final DiscussionSearchProperties discussionSearchProperties;
    private final Map<String, String> sortFilterPropertyMap;

    public DefaultDiscussionService(DiscussionRepository discussionRepository, DiscussionMapper discussionMapper, DiscussionSearchProperties discussionSearchProperties, DefaultSearchProperties defaultSearchProperties) {
        this.discussionRepository = discussionRepository;
        this.discussionMapper = discussionMapper;
        this.discussionSearchProperties = discussionSearchProperties;
        this.sortFilterPropertyMap = this.buildSortFilterPropertyMap(discussionSearchProperties.search(), defaultSearchProperties.search().sortFilterPropertyMap());
    }

    @Transactional
    @org.springframework.lang.NonNull
    public OutputDiscussionDto upsertDocument(@org.springframework.lang.NonNull InputDiscussionDto dto) {
        Discussion discussion = this.discussionMapper.toEntity(dto);
        Discussion savedDiscussion = (Discussion)this.discussionRepository.save((Object)discussion);
        return this.discussionMapper.toDto(savedDiscussion);
    }

    @Transactional(readOnly=true)
    @org.springframework.lang.NonNull
    public OutputDiscussionDto getDocument(@org.springframework.lang.NonNull String id) {
        Discussion savedDiscussion = (Discussion)this.discussionRepository.findById((Object)id).orElseThrow(() -> new WP2ResourceNotFoundException("search_dm_discussion_not_found"));
        return this.discussionMapper.toDto(savedDiscussion);
    }

    @Transactional
    public void deleteDocument(@org.springframework.lang.NonNull String id) {
        if (!this.discussionRepository.existsById((Object)id)) {
            throw new WP2ResourceNotFoundException("search_dm_discussion_not_found");
        }
        this.discussionRepository.deleteById((Object)id);
    }

    public void deleteAll() {
        if (!this.discussionSearchProperties.search().enableDeleteAll()) {
            throw new WP2BusinessException("search_dm_discussion_delete_all_not_enabled");
        }
        this.discussionRepository.deleteAll();
    }

    @org.springframework.lang.NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchAutoCompleteDto> getAutoCompletions(@org.springframework.lang.NonNull String terms) {
        Page resultPage = this.search(SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(List.of())).build(), this.discussionSearchProperties.search().autoCompletion().sourceFields(), arg_0 -> ((DiscussionMapper)this.discussionMapper).toAutoCompleteDataDto(arg_0), (Pageable)PageRequest.of((int)0, (int)this.discussionSearchProperties.search().autoCompletion().topHitsLimit()));
        if (resultPage.isEmpty()) {
            return List.of();
        }
        return List.of(OutputGlobalSearchAutoCompleteDto.builder().category(Category.DISCUSSION.getId()).data(resultPage.getContent()).build());
    }

    @org.springframework.lang.NonNull
    @Transactional(readOnly=true)
    public Page<OutputDiscussionLocalSearchDto> getLocalSearch(String terms, String filters, @org.springframework.lang.NonNull Pageable pageable) {
        SearchRequest searchRequest = SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(this.buildQueryFilters(filters, this.sortFilterPropertyMap))).build();
        Pageable sortedPageable = this.applySort(pageable, this.discussionSearchProperties.search(), this.sortFilterPropertyMap);
        return this.search(searchRequest, this.discussionSearchProperties.search().local().sourceFields(), arg_0 -> ((DiscussionMapper)this.discussionMapper).toLocalSearchDto(arg_0), sortedPageable);
    }

    @org.springframework.lang.NonNull
    @Transactional(readOnly=true)
    public List<OutputGlobalSearchDto> getSearch(@org.springframework.lang.NonNull String terms) {
        Map searchResultAggregatedByType = this.searchByAggregation(SearchRequest.builder().terms(terms).queryFilters(this.addDefaultFilters(List.of())).build(), this.discussionSearchProperties.search().globalSearch().sourceFields(), this.discussionSearchProperties.search().globalSearch().topHitsLimit().intValue(), this.discussionSearchProperties.search().globalSearch().aggregation(), arg_0 -> ((DiscussionMapper)this.discussionMapper).toGlobalSearchDataDto(arg_0));
        if (searchResultAggregatedByType.isEmpty()) {
            return List.of();
        }
        ArrayList<OutputGlobalSearchDto> globalSearchResults = new ArrayList<OutputGlobalSearchDto>();
        searchResultAggregatedByType.forEach((type, results) -> globalSearchResults.add(OutputGlobalSearchDto.builder().category(Category.DISCUSSION.getId()).type(type).data(results).build()));
        return globalSearchResults;
    }

    public void onApplicationEvent(@org.springframework.lang.NonNull UserProfileUpdatedEvent event) {
        try {
            if (event.isUserProfileMinimalUpdated()) {
                this.syncDocumentsForUserProfile(event.getUserProfile());
            }
        }
        catch (Exception ex) {
            log.error("Error occurred while syncing events for user profile with id - {}", (Object)event.getUserProfile().getId(), (Object)ex);
        }
    }

    @org.springframework.lang.NonNull
    public Page<Discussion> searchDocumentsForUserProfileSync(@org.springframework.lang.NonNull SearchRequest searchRequest, @org.springframework.lang.NonNull Pageable pageable) {
        return this.search(searchRequest, null, Function.identity(), pageable);
    }

    public void syncDocumentForUserProfile(@org.springframework.lang.NonNull Discussion discussion, @org.springframework.lang.NonNull UserProfile userProfile) {
        boolean updated = false;
        if (discussion.getUserInfoDTO() != null && Objects.equals(discussion.getUserInfoDTO().getId(), userProfile.getId()) && this.isDiscussionUserProfileUpdated(discussion.getUserInfoDTO(), userProfile)) {
            this.updateDiscussionUserInfo(discussion.getUserInfoDTO(), userProfile);
            updated = true;
        }
        if (updated) {
            this.discussionRepository.save((Object)discussion);
        }
    }

    @org.springframework.lang.NonNull
    public Class<Discussion> getDocumentClass() {
        return Discussion.class;
    }

    @org.springframework.lang.NonNull
    public SearchProperties getSearchProperties() {
        return this.discussionSearchProperties.search();
    }

    @org.springframework.lang.NonNull
    public CustomQueryRepository getCustomQueryRepository() {
        return this.discussionRepository;
    }

    @org.springframework.lang.NonNull
    public CustomAggregationRepository getCustomAggregationRepository() {
        return this.discussionRepository;
    }

    @org.springframework.lang.NonNull
    public Optional<String> getCreatorUserIdFieldName() {
        return Optional.of(CREATOR_USER_ID_FIELD_NAME);
    }

    public @NonNull PostProcessFilterResult postProcessQueryFilter(@NonNull QueryFilter queryFilter) {
        if (FILTER_KEY_VISIBILITY.equals(queryFilter.fieldName())) {
            return PostProcessFilterResult.builder().processed(true).skip(true).build();
        }
        return super.postProcessQueryFilter(queryFilter);
    }

    private List<QueryFilter> addDefaultFilters(@org.springframework.lang.NonNull List<QueryFilter> queryFilters) {
        ArrayList<QueryFilter> filtersWithDefaults = new ArrayList<QueryFilter>(queryFilters);
        filtersWithDefaults.add(QueryFilter.builder().fieldName(FILTER_KEY_VISIBILITY).filterValues(FILTER_VISIBILITY_DEFAULT_VALUE).build());
        return filtersWithDefaults;
    }

    private boolean isDiscussionUserProfileUpdated(@org.springframework.lang.NonNull Discussion.UserInfo userInfo, @org.springframework.lang.NonNull UserProfile userProfile) {
        return !Objects.equals(userInfo.getFirstName(), userProfile.getFirstName()) || !Objects.equals(userInfo.getLastName(), userProfile.getLastName()) || !Objects.equals(userInfo.getEmail(), userProfile.getEmail()) || !Objects.equals(userInfo.getImageUrl(), userProfile.getImageUrl()) || !Objects.equals(userInfo.getShortBio(), userProfile.getShortBio()) || !Objects.equals(userInfo.getOrcid(), userProfile.getOrcid());
    }

    private void updateDiscussionUserInfo(@org.springframework.lang.NonNull Discussion.UserInfo userInfo, @org.springframework.lang.NonNull UserProfile userProfile) {
        userInfo.setFirstName(userProfile.getFirstName());
        userInfo.setLastName(userProfile.getLastName());
        userInfo.setEmail(userProfile.getEmail());
        userInfo.setImageUrl(userProfile.getImageUrl());
        userInfo.setShortBio(userProfile.getShortBio());
        userInfo.setOrcid(userProfile.getOrcid());
    }
}

