/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedEndorsementEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedExpertiseEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.Instant;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="archived_endorsement")
public class ArchivedEndorsementEntity
extends AbstractUUIDEntity {
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="expertise_id", nullable=false)
    private ArchivedExpertiseEntity expertise;
    @Column(name="endorser_id")
    private UUID endorserId;
    @Column(name="endorsement_order", nullable=false)
    private long endorsementOrder;
    @Column(name="creation_time", nullable=false)
    private Instant creationTime;
    @Column(name="update_time", nullable=false)
    private Instant updateTime;
    @Column(name="archive_time", nullable=false)
    private Instant archiveTime;
    @Column(name="version", nullable=false)
    private long version;

    public void prePersist() {
        super.prePersist();
        Instant now = Instant.now();
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
        if (this.archiveTime == null) {
            this.archiveTime = now;
        }
    }

    @Generated
    protected ArchivedEndorsementEntity(ArchivedEndorsementEntityBuilder<?, ?> b) {
        super(b);
        this.expertise = b.expertise;
        this.endorserId = b.endorserId;
        this.endorsementOrder = b.endorsementOrder;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.archiveTime = b.archiveTime;
        this.version = b.version;
    }

    @Generated
    public static ArchivedEndorsementEntityBuilder<?, ?> builder() {
        return new ArchivedEndorsementEntityBuilderImpl();
    }

    @Generated
    public ArchivedExpertiseEntity getExpertise() {
        return this.expertise;
    }

    @Generated
    public UUID getEndorserId() {
        return this.endorserId;
    }

    @Generated
    public long getEndorsementOrder() {
        return this.endorsementOrder;
    }

    @Generated
    public Instant getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public Instant getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public Instant getArchiveTime() {
        return this.archiveTime;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setExpertise(ArchivedExpertiseEntity expertise) {
        this.expertise = expertise;
    }

    @Generated
    public void setEndorserId(UUID endorserId) {
        this.endorserId = endorserId;
    }

    @Generated
    public void setEndorsementOrder(long endorsementOrder) {
        this.endorsementOrder = endorsementOrder;
    }

    @Generated
    public void setCreationTime(Instant creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(Instant updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setArchiveTime(Instant archiveTime) {
        this.archiveTime = archiveTime;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArchivedEndorsementEntity)) {
            return false;
        }
        ArchivedEndorsementEntity other = (ArchivedEndorsementEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getEndorsementOrder() != other.getEndorsementOrder()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        ArchivedExpertiseEntity this$expertise = this.getExpertise();
        ArchivedExpertiseEntity other$expertise = other.getExpertise();
        if (this$expertise == null ? other$expertise != null : !this$expertise.equals(other$expertise)) {
            return false;
        }
        UUID this$endorserId = this.getEndorserId();
        UUID other$endorserId = other.getEndorserId();
        if (this$endorserId == null ? other$endorserId != null : !((Object)this$endorserId).equals(other$endorserId)) {
            return false;
        }
        Instant this$creationTime = this.getCreationTime();
        Instant other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        Instant this$updateTime = this.getUpdateTime();
        Instant other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        Instant this$archiveTime = this.getArchiveTime();
        Instant other$archiveTime = other.getArchiveTime();
        return !(this$archiveTime == null ? other$archiveTime != null : !((Object)this$archiveTime).equals(other$archiveTime));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArchivedEndorsementEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $endorsementOrder = this.getEndorsementOrder();
        result = result * 59 + (int)($endorsementOrder >>> 32 ^ $endorsementOrder);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        ArchivedExpertiseEntity $expertise = this.getExpertise();
        result = result * 59 + ($expertise == null ? 43 : $expertise.hashCode());
        UUID $endorserId = this.getEndorserId();
        result = result * 59 + ($endorserId == null ? 43 : ((Object)$endorserId).hashCode());
        Instant $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        Instant $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        Instant $archiveTime = this.getArchiveTime();
        result = result * 59 + ($archiveTime == null ? 43 : ((Object)$archiveTime).hashCode());
        return result;
    }

    @Generated
    public ArchivedEndorsementEntity() {
    }
}

