/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.entity;

import com.finconsgroup.itserr.marketplace.core.entity.AbstractUUIDEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.CVEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ProjectEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ReferenceEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserPreferenceEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.WorkingLocationEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.converter.StringListConverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.Lob;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.OrderColumn;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import lombok.Generated;

@Entity
@Table(name="user_profile")
public class UserProfileEntity
extends AbstractUUIDEntity {
    @Column(name="first_name", nullable=false)
    private String firstName;
    @Column(name="last_name", nullable=false)
    private String lastName;
    @Column(name="email", nullable=false)
    private String email;
    @Column(name="preferred_username", nullable=false)
    private String preferredUsername;
    @Column(name="profile_folder_id", nullable=false)
    private UUID userProfileFolderId;
    @Column(name="image_url")
    private String imageUrl;
    @Column(name="orcid")
    private String orcid;
    @Column(name="open_to_collaboration", nullable=false)
    private boolean openToCollaboration;
    @Column(name="show_public_email", nullable=false)
    private boolean showPublicEmail;
    @Column(name="personal_website")
    private String personalWebsite;
    @Column(name="linkedin_profile")
    private String linkedinProfile;
    @Column(name="social_profile")
    private String socialProfile;
    @Column(name="short_bio", length=1000)
    private String shortBio;
    @Column(name="organization_affiliation", nullable=false)
    private String organizationAffiliation;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="ssd")
    private List<String> ssd;
    @OneToMany(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true)
    @OrderColumn(name="expertise_order")
    private List<ExpertiseEntity> expertises;
    @OneToOne(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true)
    private CVEntity cv;
    @OneToOne(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true)
    private WorkingLocationEntity workingLocation;
    @OneToOne(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true)
    private ReferenceEntity references;
    @OneToMany(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<ProjectEntity> projects;
    @Column(name="public_profile", nullable=false)
    private boolean publicProfile;
    @Lob
    @Convert(converter=StringListConverter.class)
    @Column(name="interests")
    private List<String> interests;
    @OneToOne(mappedBy="userProfile", cascade={CascadeType.ALL}, orphanRemoval=true)
    private UserPreferenceEntity preferences;
    @Column(name="hide_panel", nullable=false)
    private boolean hidePanel;
    @Column(name="creation_time", nullable=false, updatable=false)
    private ZonedDateTime creationTime;
    @Column(name="update_time", nullable=false)
    private ZonedDateTime updateTime;
    @Column(name="language", nullable=false)
    private String language;
    @Column(name="email_consent", nullable=false)
    private boolean emailConsent;
    @Version
    private long version;

    public void prePersist() {
        super.prePersist();
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
        if (this.creationTime == null) {
            this.creationTime = now;
        }
        if (this.updateTime == null) {
            this.updateTime = now;
        }
    }

    @PreUpdate
    public void onUpdate() {
        this.updateTime = ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MICROS);
    }

    @Generated
    protected UserProfileEntity(UserProfileEntityBuilder<?, ?> b) {
        super(b);
        this.firstName = b.firstName;
        this.lastName = b.lastName;
        this.email = b.email;
        this.preferredUsername = b.preferredUsername;
        this.userProfileFolderId = b.userProfileFolderId;
        this.imageUrl = b.imageUrl;
        this.orcid = b.orcid;
        this.openToCollaboration = b.openToCollaboration;
        this.showPublicEmail = b.showPublicEmail;
        this.personalWebsite = b.personalWebsite;
        this.linkedinProfile = b.linkedinProfile;
        this.socialProfile = b.socialProfile;
        this.shortBio = b.shortBio;
        this.organizationAffiliation = b.organizationAffiliation;
        this.ssd = b.ssd;
        this.expertises = b.expertises;
        this.cv = b.cv;
        this.workingLocation = b.workingLocation;
        this.references = b.references;
        this.projects = b.projects;
        this.publicProfile = b.publicProfile;
        this.interests = b.interests;
        this.preferences = b.preferences;
        this.hidePanel = b.hidePanel;
        this.creationTime = b.creationTime;
        this.updateTime = b.updateTime;
        this.language = b.language;
        this.emailConsent = b.emailConsent;
        this.version = b.version;
    }

    @Generated
    public static UserProfileEntityBuilder<?, ?> builder() {
        return new UserProfileEntityBuilderImpl();
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getPreferredUsername() {
        return this.preferredUsername;
    }

    @Generated
    public UUID getUserProfileFolderId() {
        return this.userProfileFolderId;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getOrcid() {
        return this.orcid;
    }

    @Generated
    public boolean isOpenToCollaboration() {
        return this.openToCollaboration;
    }

    @Generated
    public boolean isShowPublicEmail() {
        return this.showPublicEmail;
    }

    @Generated
    public String getPersonalWebsite() {
        return this.personalWebsite;
    }

    @Generated
    public String getLinkedinProfile() {
        return this.linkedinProfile;
    }

    @Generated
    public String getSocialProfile() {
        return this.socialProfile;
    }

    @Generated
    public String getShortBio() {
        return this.shortBio;
    }

    @Generated
    public String getOrganizationAffiliation() {
        return this.organizationAffiliation;
    }

    @Generated
    public List<String> getSsd() {
        return this.ssd;
    }

    @Generated
    public List<ExpertiseEntity> getExpertises() {
        return this.expertises;
    }

    @Generated
    public CVEntity getCv() {
        return this.cv;
    }

    @Generated
    public WorkingLocationEntity getWorkingLocation() {
        return this.workingLocation;
    }

    @Generated
    public ReferenceEntity getReferences() {
        return this.references;
    }

    @Generated
    public List<ProjectEntity> getProjects() {
        return this.projects;
    }

    @Generated
    public boolean isPublicProfile() {
        return this.publicProfile;
    }

    @Generated
    public List<String> getInterests() {
        return this.interests;
    }

    @Generated
    public UserPreferenceEntity getPreferences() {
        return this.preferences;
    }

    @Generated
    public boolean isHidePanel() {
        return this.hidePanel;
    }

    @Generated
    public ZonedDateTime getCreationTime() {
        return this.creationTime;
    }

    @Generated
    public ZonedDateTime getUpdateTime() {
        return this.updateTime;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isEmailConsent() {
        return this.emailConsent;
    }

    @Generated
    public long getVersion() {
        return this.version;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setPreferredUsername(String preferredUsername) {
        this.preferredUsername = preferredUsername;
    }

    @Generated
    public void setUserProfileFolderId(UUID userProfileFolderId) {
        this.userProfileFolderId = userProfileFolderId;
    }

    @Generated
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    @Generated
    public void setOrcid(String orcid) {
        this.orcid = orcid;
    }

    @Generated
    public void setOpenToCollaboration(boolean openToCollaboration) {
        this.openToCollaboration = openToCollaboration;
    }

    @Generated
    public void setShowPublicEmail(boolean showPublicEmail) {
        this.showPublicEmail = showPublicEmail;
    }

    @Generated
    public void setPersonalWebsite(String personalWebsite) {
        this.personalWebsite = personalWebsite;
    }

    @Generated
    public void setLinkedinProfile(String linkedinProfile) {
        this.linkedinProfile = linkedinProfile;
    }

    @Generated
    public void setSocialProfile(String socialProfile) {
        this.socialProfile = socialProfile;
    }

    @Generated
    public void setShortBio(String shortBio) {
        this.shortBio = shortBio;
    }

    @Generated
    public void setOrganizationAffiliation(String organizationAffiliation) {
        this.organizationAffiliation = organizationAffiliation;
    }

    @Generated
    public void setSsd(List<String> ssd) {
        this.ssd = ssd;
    }

    @Generated
    public void setExpertises(List<ExpertiseEntity> expertises) {
        this.expertises = expertises;
    }

    @Generated
    public void setCv(CVEntity cv) {
        this.cv = cv;
    }

    @Generated
    public void setWorkingLocation(WorkingLocationEntity workingLocation) {
        this.workingLocation = workingLocation;
    }

    @Generated
    public void setReferences(ReferenceEntity references) {
        this.references = references;
    }

    @Generated
    public void setProjects(List<ProjectEntity> projects) {
        this.projects = projects;
    }

    @Generated
    public void setPublicProfile(boolean publicProfile) {
        this.publicProfile = publicProfile;
    }

    @Generated
    public void setInterests(List<String> interests) {
        this.interests = interests;
    }

    @Generated
    public void setPreferences(UserPreferenceEntity preferences) {
        this.preferences = preferences;
    }

    @Generated
    public void setHidePanel(boolean hidePanel) {
        this.hidePanel = hidePanel;
    }

    @Generated
    public void setCreationTime(ZonedDateTime creationTime) {
        this.creationTime = creationTime;
    }

    @Generated
    public void setUpdateTime(ZonedDateTime updateTime) {
        this.updateTime = updateTime;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setEmailConsent(boolean emailConsent) {
        this.emailConsent = emailConsent;
    }

    @Generated
    public void setVersion(long version) {
        this.version = version;
    }

    @Generated
    public String toString() {
        return "UserProfileEntity(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", email=" + this.getEmail() + ", preferredUsername=" + this.getPreferredUsername() + ", userProfileFolderId=" + String.valueOf(this.getUserProfileFolderId()) + ", imageUrl=" + this.getImageUrl() + ", orcid=" + this.getOrcid() + ", openToCollaboration=" + this.isOpenToCollaboration() + ", showPublicEmail=" + this.isShowPublicEmail() + ", personalWebsite=" + this.getPersonalWebsite() + ", linkedinProfile=" + this.getLinkedinProfile() + ", socialProfile=" + this.getSocialProfile() + ", shortBio=" + this.getShortBio() + ", organizationAffiliation=" + this.getOrganizationAffiliation() + ", ssd=" + String.valueOf(this.getSsd()) + ", cv=" + String.valueOf(this.getCv()) + ", workingLocation=" + String.valueOf(this.getWorkingLocation()) + ", references=" + String.valueOf(this.getReferences()) + ", projects=" + String.valueOf(this.getProjects()) + ", publicProfile=" + this.isPublicProfile() + ", interests=" + String.valueOf(this.getInterests()) + ", preferences=" + String.valueOf(this.getPreferences()) + ", hidePanel=" + this.isHidePanel() + ", creationTime=" + String.valueOf(this.getCreationTime()) + ", updateTime=" + String.valueOf(this.getUpdateTime()) + ", language=" + this.getLanguage() + ", emailConsent=" + this.isEmailConsent() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserProfileEntity)) {
            return false;
        }
        UserProfileEntity other = (UserProfileEntity)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isOpenToCollaboration() != other.isOpenToCollaboration()) {
            return false;
        }
        if (this.isShowPublicEmail() != other.isShowPublicEmail()) {
            return false;
        }
        if (this.isPublicProfile() != other.isPublicProfile()) {
            return false;
        }
        if (this.isHidePanel() != other.isHidePanel()) {
            return false;
        }
        if (this.isEmailConsent() != other.isEmailConsent()) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$preferredUsername = this.getPreferredUsername();
        String other$preferredUsername = other.getPreferredUsername();
        if (this$preferredUsername == null ? other$preferredUsername != null : !this$preferredUsername.equals(other$preferredUsername)) {
            return false;
        }
        UUID this$userProfileFolderId = this.getUserProfileFolderId();
        UUID other$userProfileFolderId = other.getUserProfileFolderId();
        if (this$userProfileFolderId == null ? other$userProfileFolderId != null : !((Object)this$userProfileFolderId).equals(other$userProfileFolderId)) {
            return false;
        }
        String this$imageUrl = this.getImageUrl();
        String other$imageUrl = other.getImageUrl();
        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
            return false;
        }
        String this$orcid = this.getOrcid();
        String other$orcid = other.getOrcid();
        if (this$orcid == null ? other$orcid != null : !this$orcid.equals(other$orcid)) {
            return false;
        }
        String this$personalWebsite = this.getPersonalWebsite();
        String other$personalWebsite = other.getPersonalWebsite();
        if (this$personalWebsite == null ? other$personalWebsite != null : !this$personalWebsite.equals(other$personalWebsite)) {
            return false;
        }
        String this$linkedinProfile = this.getLinkedinProfile();
        String other$linkedinProfile = other.getLinkedinProfile();
        if (this$linkedinProfile == null ? other$linkedinProfile != null : !this$linkedinProfile.equals(other$linkedinProfile)) {
            return false;
        }
        String this$socialProfile = this.getSocialProfile();
        String other$socialProfile = other.getSocialProfile();
        if (this$socialProfile == null ? other$socialProfile != null : !this$socialProfile.equals(other$socialProfile)) {
            return false;
        }
        String this$shortBio = this.getShortBio();
        String other$shortBio = other.getShortBio();
        if (this$shortBio == null ? other$shortBio != null : !this$shortBio.equals(other$shortBio)) {
            return false;
        }
        String this$organizationAffiliation = this.getOrganizationAffiliation();
        String other$organizationAffiliation = other.getOrganizationAffiliation();
        if (this$organizationAffiliation == null ? other$organizationAffiliation != null : !this$organizationAffiliation.equals(other$organizationAffiliation)) {
            return false;
        }
        List this$ssd = this.getSsd();
        List other$ssd = other.getSsd();
        if (this$ssd == null ? other$ssd != null : !((Object)this$ssd).equals(other$ssd)) {
            return false;
        }
        List this$expertises = this.getExpertises();
        List other$expertises = other.getExpertises();
        if (this$expertises == null ? other$expertises != null : !((Object)this$expertises).equals(other$expertises)) {
            return false;
        }
        CVEntity this$cv = this.getCv();
        CVEntity other$cv = other.getCv();
        if (this$cv == null ? other$cv != null : !this$cv.equals(other$cv)) {
            return false;
        }
        WorkingLocationEntity this$workingLocation = this.getWorkingLocation();
        WorkingLocationEntity other$workingLocation = other.getWorkingLocation();
        if (this$workingLocation == null ? other$workingLocation != null : !this$workingLocation.equals(other$workingLocation)) {
            return false;
        }
        ReferenceEntity this$references = this.getReferences();
        ReferenceEntity other$references = other.getReferences();
        if (this$references == null ? other$references != null : !this$references.equals(other$references)) {
            return false;
        }
        List this$projects = this.getProjects();
        List other$projects = other.getProjects();
        if (this$projects == null ? other$projects != null : !((Object)this$projects).equals(other$projects)) {
            return false;
        }
        List this$interests = this.getInterests();
        List other$interests = other.getInterests();
        if (this$interests == null ? other$interests != null : !((Object)this$interests).equals(other$interests)) {
            return false;
        }
        UserPreferenceEntity this$preferences = this.getPreferences();
        UserPreferenceEntity other$preferences = other.getPreferences();
        if (this$preferences == null ? other$preferences != null : !this$preferences.equals(other$preferences)) {
            return false;
        }
        ZonedDateTime this$creationTime = this.getCreationTime();
        ZonedDateTime other$creationTime = other.getCreationTime();
        if (this$creationTime == null ? other$creationTime != null : !((Object)this$creationTime).equals(other$creationTime)) {
            return false;
        }
        ZonedDateTime this$updateTime = this.getUpdateTime();
        ZonedDateTime other$updateTime = other.getUpdateTime();
        if (this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UserProfileEntity;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isOpenToCollaboration() ? 79 : 97);
        result = result * 59 + (this.isShowPublicEmail() ? 79 : 97);
        result = result * 59 + (this.isPublicProfile() ? 79 : 97);
        result = result * 59 + (this.isHidePanel() ? 79 : 97);
        result = result * 59 + (this.isEmailConsent() ? 79 : 97);
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $preferredUsername = this.getPreferredUsername();
        result = result * 59 + ($preferredUsername == null ? 43 : $preferredUsername.hashCode());
        UUID $userProfileFolderId = this.getUserProfileFolderId();
        result = result * 59 + ($userProfileFolderId == null ? 43 : ((Object)$userProfileFolderId).hashCode());
        String $imageUrl = this.getImageUrl();
        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
        String $orcid = this.getOrcid();
        result = result * 59 + ($orcid == null ? 43 : $orcid.hashCode());
        String $personalWebsite = this.getPersonalWebsite();
        result = result * 59 + ($personalWebsite == null ? 43 : $personalWebsite.hashCode());
        String $linkedinProfile = this.getLinkedinProfile();
        result = result * 59 + ($linkedinProfile == null ? 43 : $linkedinProfile.hashCode());
        String $socialProfile = this.getSocialProfile();
        result = result * 59 + ($socialProfile == null ? 43 : $socialProfile.hashCode());
        String $shortBio = this.getShortBio();
        result = result * 59 + ($shortBio == null ? 43 : $shortBio.hashCode());
        String $organizationAffiliation = this.getOrganizationAffiliation();
        result = result * 59 + ($organizationAffiliation == null ? 43 : $organizationAffiliation.hashCode());
        List $ssd = this.getSsd();
        result = result * 59 + ($ssd == null ? 43 : ((Object)$ssd).hashCode());
        List $expertises = this.getExpertises();
        result = result * 59 + ($expertises == null ? 43 : ((Object)$expertises).hashCode());
        CVEntity $cv = this.getCv();
        result = result * 59 + ($cv == null ? 43 : $cv.hashCode());
        WorkingLocationEntity $workingLocation = this.getWorkingLocation();
        result = result * 59 + ($workingLocation == null ? 43 : $workingLocation.hashCode());
        ReferenceEntity $references = this.getReferences();
        result = result * 59 + ($references == null ? 43 : $references.hashCode());
        List $projects = this.getProjects();
        result = result * 59 + ($projects == null ? 43 : ((Object)$projects).hashCode());
        List $interests = this.getInterests();
        result = result * 59 + ($interests == null ? 43 : ((Object)$interests).hashCode());
        UserPreferenceEntity $preferences = this.getPreferences();
        result = result * 59 + ($preferences == null ? 43 : $preferences.hashCode());
        ZonedDateTime $creationTime = this.getCreationTime();
        result = result * 59 + ($creationTime == null ? 43 : ((Object)$creationTime).hashCode());
        ZonedDateTime $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }

    @Generated
    public UserProfileEntity() {
    }
}

