package com.finconsgroup.itserr.marketplace.userprofile.dm.controller;

import com.finconsgroup.itserr.marketplace.core.web.security.jwt.JwtTokenHolder;
import com.finconsgroup.itserr.marketplace.userprofile.dm.api.AdminApi;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.service.AdminService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RestController;

import java.util.UUID;

/**
 * REST controller class for handling UserProfile related API requests.
 *
 * <p>Implements the {@link AdminApi} interface.</p>
 */
@Slf4j
@RequiredArgsConstructor
@RestController
public class AdminController implements AdminApi {

    private final AdminService adminService;

    @Override
    public OutputAdminPatchUserProfileDto patchUserProfile(UUID profileId, InputAdminPatchUserProfileDto inputAdminPatchUserProfileDto) {
        JwtTokenHolder.getUserIdOrThrow();
        return adminService.patchUserProfile(profileId, inputAdminPatchUserProfileDto);
    }
}
