package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Size;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.net.URI;

import static com.finconsgroup.itserr.marketplace.userprofile.dm.util.Constants.VALIDATION_ERROR_FIELD_LENGTH;

/**
 * DTO for patching user profile info.
 */
@Schema(name = "PatchUserProfileDto", description = "DTO for patching user profile details")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class OutputPatchUserProfileDto {

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    @Size(max = 255, message = VALIDATION_ERROR_FIELD_LENGTH)
    URI imageUri;

    @Schema(description = "CV details of the user")
    OutputCVDto outputCVDto;

    @Schema(description = "User preferred language", example = "EN")
    String language;

    @Schema(description = "Consent to receive notifications via email", example = "true")
    Boolean emailConsent;

    @Schema(description = "Whether to show home panel or not", example = "false")
    Boolean hidePanel;
}
