package com.finconsgroup.itserr.marketplace.userprofile.dm.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.UUID;

/**
 * Output DTO representing a autocomplete userprofile.
 */
@Schema(name = "OutputUserProfileAutoCompleteDto", description = "Represents the response for user profile auto complete")
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class OutputUserProfileAutoCompleteDto {
    @Schema(description = "Unique identifier of the user profile", example = "550e8400-e29b-41d4-a716-446655440000")
    private UUID id;

    @Schema(description = "First name of the user", example = "John")
    private String firstName;

    @Schema(description = "Last name of the user", example = "Doe")
    private String lastName;

    @Schema(description = "preferred Username of the user", example = "john.doe.213213")
    private String preferredUsername;

    @Schema(description = "Email address of the user", example = "john.doe@example.com")
    private String email;

    @Schema(description = "Link of the image of user", example = "https://imageLink")
    private String imageUrl;

}
