package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ArchivedExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;

@Mapper(config = MapperConfiguration.class, uses = {ArchivedEndorsementMapper.class})
public interface ArchivedExpertiseMapper {

    /**
     * Maps a {@link ExpertiseEntity} into a {@link ArchivedExpertiseEntity}.
     *
     * @param src Source request.
     * @return Mapped entity.
     */
    @Mapping(target = "archiveTime", ignore = true)
    ArchivedExpertiseEntity toArchivedEntity(ExpertiseEntity src);
}
