package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementAcknowledgementDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.EndorsementEntity;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.springframework.lang.NonNull;

import java.util.UUID;

@Mapper(config = MapperConfiguration.class)
public interface EndorsementMapper {

    @Mapping(target = "firstName", ignore = true)
    @Mapping(target = "lastName", ignore = true)
    @Mapping(target = "preferredUsername", ignore = true)
    @Mapping(target = "email", ignore = true)
    @Mapping(target = "imageUrl", ignore = true)
    @Mapping(target = "shortBio", ignore = true)
    OutputEndorsementDto toDto(EndorsementEntity entity);

    @Mapping(target = "id", source = "entity.id")
    @Mapping(target = "creationTime", source = "entity.creationTime")
    @Mapping(target = "updateTime", source = "entity.updateTime")
    @Mapping(target = "endorsedId", source = "profileId")
    @Mapping(target = "expertiseDisplayName", source = "displayName")
    OutputEndorsementAcknowledgementDto toEndorsementAcknowledgementDto(EndorsementEntity entity,
                                                                        OutputUserProfileDto userProfileDto,
                                                                        UUID profileId,
                                                                        String displayName);

}
