package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputWorkingLocationDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputEndorsementDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ExpertiseEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.WorkingLocationEntity;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValueMappingStrategy;

@Mapper(config = MapperConfiguration.class)
public interface ExpertiseMapper {

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "userProfile", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "expertiseOrder", ignore = true)
    @Mapping(target = "endorsementCount", ignore = true)
    @Mapping(target = "endorsements", ignore = true)
    ExpertiseEntity toEntity(InputExpertiseDto dto);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "userProfile", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    @Mapping(target = "labelId", ignore = true)
    @Mapping(target = "expertiseOrder", ignore = true)
    @Mapping(target = "endorsementCount", ignore = true)
    @Mapping(target = "endorsements", ignore = true)
    @IterableMapping(nullValueMappingStrategy = NullValueMappingStrategy.RETURN_DEFAULT)
    void updateEntity(InputExpertiseDto dto, @MappingTarget ExpertiseEntity entity);
}
