package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputManualReferenceDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.ManualReferenceEntity;
import org.mapstruct.AfterMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;

@Mapper(config = MapperConfiguration.class, uses = {AuthorMapper.class, PublicationMapper.class})
public interface ManualReferenceMapper {
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "reference", ignore = true)
    @Mapping(target = "creationTime", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    @Mapping(target = "version", ignore = true)
    ManualReferenceEntity toEntity(InputManualReferenceDto model);

    OutputManualReferenceDto toDto(ManualReferenceEntity entity);

    @AfterMapping
    default void setAuthors(@MappingTarget ManualReferenceEntity manualReferenceEntity) {
        if (manualReferenceEntity != null && manualReferenceEntity.getAuthors() != null) {
            manualReferenceEntity.getAuthors().forEach(authorEntity -> authorEntity.setReferenceDetails(manualReferenceEntity));
        }
    }

    @AfterMapping
    default void setPublication(@MappingTarget ManualReferenceEntity manualReferenceEntity) {
        if (manualReferenceEntity != null && manualReferenceEntity.getPublication() != null) {
            manualReferenceEntity.getPublication().setReferenceDetails(manualReferenceEntity);
        }
    }
}
