package com.finconsgroup.itserr.marketplace.userprofile.dm.validation;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputExpertiseDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.validation.annotation.ValidInputCreateOrUpdateUserProfileDto;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import org.springframework.stereotype.Component;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

@Component
public class InputCreateOrUpdateUserProfileDtoValidator implements ConstraintValidator<ValidInputCreateOrUpdateUserProfileDto, Object> {

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        boolean valid = true;

        switch (value) {
            case null -> {
                return valid;
            }
            case InputUserProfileDto inputUserProfileDto ->
                    valid = validateExpertise(context, inputUserProfileDto.getExpertises());
            case InputUpdateUserProfileDto inputUpdateUserProfileDto ->
                    valid = validateExpertise(context, inputUpdateUserProfileDto.getExpertises());
            default -> {
            }
        }

        return valid;
    }

    private boolean validateExpertise(ConstraintValidatorContext context,
                                      List<InputExpertiseDto> inputExpertises) {

        if (inputExpertises == null) {
            return true;
        }

        boolean valid = true;

        // Detect duplicates in input
        Set<UUID> seen = new HashSet<>();
        Set<UUID> duplicates = new HashSet<>();
        for (InputExpertiseDto dto : inputExpertises) {
            UUID labelId = dto.getLabelId();
            if (labelId != null && !seen.add(labelId)) {
                duplicates.add(labelId);
            }
        }

        if (!duplicates.isEmpty()) {
            context.buildConstraintViolationWithTemplate("duplicate_expertise_label_ids_found: " + duplicates)
                    .addConstraintViolation();
            valid = false;
        }

        return valid;
    }
}
