package com.finconsgroup.itserr.marketplace.userprofile.dm.validation.annotation;

import com.finconsgroup.itserr.marketplace.userprofile.dm.validation.InputCreateOrUpdateUserProfileDtoValidator;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation to enable the validation for {@link com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto}
 */
@Target({ElementType.PARAMETER, ElementType.FIELD})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy = InputCreateOrUpdateUserProfileDtoValidator.class)
@Documented
public @interface ValidInputCreateOrUpdateUserProfileDto {

    String message() default "";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};
}
