/*
 * Decompiled with CFR 0.152.
 */
package com.finconsgroup.itserr.marketplace.userprofile.dm.mapper;

import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUpdateUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.InputUserProfileStatusChangeDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputAdminPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputPatchUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.dto.OutputUserProfileDto;
import com.finconsgroup.itserr.marketplace.userprofile.dm.entity.UserProfileEntity;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.CVMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.EndorsementMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ExpertiseMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.MapperConfiguration;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ProjectMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.ReferenceMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.UserPreferenceMapper;
import com.finconsgroup.itserr.marketplace.userprofile.dm.mapper.WorkingLocationMapper;
import java.net.URI;
import java.util.UUID;
import org.mapstruct.AfterMapping;
import org.mapstruct.BeanMapping;
import org.mapstruct.IterableMapping;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.MappingTarget;
import org.mapstruct.Mappings;
import org.mapstruct.NullValueMappingStrategy;
import org.mapstruct.NullValuePropertyMappingStrategy;

@Mapper(config=MapperConfiguration.class, uses={EndorsementMapper.class, ExpertiseMapper.class, UserPreferenceMapper.class, ReferenceMapper.class, CVMapper.class, WorkingLocationMapper.class, ProjectMapper.class})
public interface UserProfileMapper {
    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="firstName", ignore=true), @Mapping(target="lastName", ignore=true), @Mapping(target="email", ignore=true), @Mapping(target="preferredUsername", ignore=true), @Mapping(target="projects", ignore=true), @Mapping(target="hidePanel", ignore=true)})
    public UserProfileEntity toEntity(InputUserProfileDto var1, UUID var2);

    @Mapping(target="userExists", ignore=true)
    public OutputUserProfileDto toDto(UserProfileEntity var1);

    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="firstName", ignore=true), @Mapping(target="lastName", ignore=true), @Mapping(target="email", ignore=true), @Mapping(target="userProfileFolderId", ignore=true), @Mapping(target="preferredUsername", ignore=true), @Mapping(target="projects", ignore=true), @Mapping(target="expertises", ignore=true), @Mapping(target="hidePanel", ignore=true), @Mapping(target="emailConsent", ignore=true)})
    @IterableMapping(nullValueMappingStrategy=NullValueMappingStrategy.RETURN_DEFAULT)
    public void updateEntity(InputUpdateUserProfileDto var1, @MappingTarget UserProfileEntity var2);

    @AfterMapping
    default public void setCV(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getCv() != null) {
            userProfile.getCv().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default public void setWorkingLocation(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getWorkingLocation() != null) {
            userProfile.getWorkingLocation().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default public void setReference(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getReferences() != null) {
            userProfile.getReferences().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default public void setProjects(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getProjects() != null) {
            userProfile.getProjects().forEach(project -> project.setUserProfile(userProfile));
        }
    }

    @AfterMapping
    default public void setPreference(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getPreferences() != null) {
            userProfile.getPreferences().setUserProfile(userProfile);
        }
    }

    @AfterMapping
    default public void setExpertise(@MappingTarget UserProfileEntity userProfile) {
        if (userProfile != null && userProfile.getExpertises() != null) {
            userProfile.getExpertises().forEach(expertise -> expertise.setUserProfile(userProfile));
        }
    }

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault=true)
    @Mappings(value={@Mapping(target="imageUrl", source="imageUri"), @Mapping(target="cv", source="inputCVDto"), @Mapping(target="language", source="language"), @Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="emailConsent", source="emailConsent"), @Mapping(target="hidePanel", source="hidePanel")})
    public void patchEntity(InputPatchUserProfileDto var1, @MappingTarget UserProfileEntity var2);

    @Mappings(value={@Mapping(target="imageUri", source="imageUrl"), @Mapping(target="outputCVDto.fileUrl", source="cv.fileUrl"), @Mapping(target="outputCVDto.filename", source="cv.filename"), @Mapping(target="outputCVDto.size", source="cv.size"), @Mapping(target="language", source="language"), @Mapping(target="emailConsent", source="emailConsent"), @Mapping(target="hidePanel", source="hidePanel")})
    public OutputPatchUserProfileDto toPatchUserDto(UserProfileEntity var1);

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault=true)
    @Mappings(value={@Mapping(target="publicProfile", source="publicProfile"), @Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true)})
    public void patchEntity(InputUserProfileStatusChangeDto var1, @MappingTarget UserProfileEntity var2);

    @BeanMapping(nullValuePropertyMappingStrategy=NullValuePropertyMappingStrategy.IGNORE, ignoreByDefault=true)
    @Mappings(value={@Mapping(target="id", ignore=true), @Mapping(target="creationTime", ignore=true), @Mapping(target="updateTime", ignore=true), @Mapping(target="version", ignore=true), @Mapping(target="publicProfile", source="publicProfile")})
    public void patchEntity(InputAdminPatchUserProfileDto var1, @MappingTarget UserProfileEntity var2);

    public OutputAdminPatchUserProfileDto toAdminPatchUserProfileDto(UserProfileEntity var1);

    default public String map(URI uri) {
        return uri == null ? null : uri.toString();
    }

    default public URI map(String uriString) {
        return uriString == null ? null : URI.create(uriString);
    }
}

